<?php
/* --------------------------------------------------------------
   LanguageId.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\Model;

/**
 * Class LanguageId
 *
 * @package Gambio\Core\Language\Model
 */
class LanguageId implements \Gambio\Core\Language\LanguageId
{
    /**
     * @var int
     */
    private $value;
    
    
    /**
     * LanguageCode constructor.
     *
     * @param int $value
     */
    private function __construct(int $value)
    {
        $this->value = $value;
    }
    
    
    /**
     * @param int $value
     *
     * @return LanguageId
     */
    public static function create(int $value): LanguageId
    {
        return new self($value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): int
    {
        return $this->value;
    }
}